#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <math.h>

/* PARAM 0xbc 0x01 0x1e 0x01 0x78 0x03 0x08 0x08 0x00 0x00 0x00 0x00 0xcf 0xa0 0x00 0x00 0x00 0x00 */

#define INFILE "Ucy300q-image.txt"
#define OUTFILE "Ucy300q-image.pnm"
#define BYTES_PER_COLOR 888
#define PIXELS_PER_LINE 444
#define SCAN_LINES 286
#define COLOR_MODE 3
#define DEPTH 16




reorder_indexed (unsigned char *buffer, unsigned char *reorder,
		 size_t chunk_size)
{
  char idx_char[4] = { 'R', 'G', 'B', 'I' };
  char *idx_ptr[4];
  char *iend_ptr[4];
  int idx_buf[4];
  int idx_found;
  unsigned char *end_ptr;
  unsigned char *dest, *src[4];
  int bytes_per_line, bytes_per_color;
  int chunk_lines, lines_todo;
  int write_lines;
  int status;
  int irgb;			/* number of color planes = values per pixel */
  int irgb_out;			/* limit output as long as SANE disregards infrared */
  int request_data, i, j;

  bytes_per_color = BYTES_PER_COLOR + 2;
  switch (COLOR_MODE)
    {
    case 3:
      irgb = 3;
      irgb_out = 3;
      bytes_per_line = bytes_per_color * 3;
      break;
    case 4:
      irgb = 4;
      irgb_out = 3;
      bytes_per_line = bytes_per_color * 4;
      break;
    default:
      return;
    }

  request_data = 0;
  chunk_lines = SCAN_LINES;
  write_lines = SCAN_LINES;
  end_ptr = buffer + bytes_per_line * write_lines;
  for (i = 0; i < irgb; i++)
    {
      idx_ptr[i] = (char *) buffer;
      iend_ptr[i] = idx_ptr[i] + chunk_size;
      idx_buf[i] = 1;
      src[i] = NULL;
    }
  idx_found = 0;
  dest = reorder;

  while (write_lines)
    {
      for (i = 0; i < irgb; i++)	/* find indices */
	{
	  while (src[i] == NULL)
	    {
	      if (*idx_ptr[i] == idx_char[i])
		{
		  src[i] = (unsigned char *) idx_ptr[i] + 2;
		  idx_found++;
		}
	      /* advance pointers unconditionally */
	      idx_ptr[i] += bytes_per_color;
	      if (idx_ptr[i] >= iend_ptr[i])
		{
		  request_data = 1;
		  break;
		}
	    }
	}

      if (idx_found == irgb)	/* success, reorder and write a line */
	{
	  if (DEPTH > 8)
	    {
	      for (j = PIXELS_PER_LINE; j > 0; j--)
		for (i = 0; i < irgb_out; i++)
		  {
		    *dest++ = *src[i]++;
		    *dest++ = *src[i]++;
		  }
	    }
	  else
	    {
	      for (j = PIXELS_PER_LINE; j > 0; j--)
		for (i = 0; i < irgb_out; i++)
		  *dest++ = *src[i]++;
	    }
	  for (i = 0; i < irgb; i++)
	    src[i] = NULL;
	  idx_found = 0;
	  write_lines--;
	}

      if (request_data)		/* read next data */
	{
	  if (write_lines)
	    {
	      printf ("reorder_indexed: deskew failed for %d lines\n",
		      write_lines);
	      write_lines = 0;
	    }
	}
    }
  return;
}


write_pnm_file (char *filename, unsigned char * data, int depth,
			      int channels, int pixels_per_line, int lines)
{
  FILE *out;
  int count;

  out = fopen (filename, "w");
  if (!out)
    {
      printf("write_pnm_file: could nor open %s for writing: %s\n",
	     filename, strerror (errno));
      return;
    }
  if(depth==1)
    {
      fprintf (out, "P4\n%d\n%d\n", pixels_per_line, lines);
    }
  else
    {
      fprintf (out, "P%c\n%d\n%d\n%d\n", channels == 1 ? '5' : '6',
	   pixels_per_line, lines, (int) pow (2, depth) - 1);
    }
  if (channels == 3)
    {
      for (count = 0; count < (pixels_per_line * lines * 3); count++)
	{
	  if (depth == 16)
	    fputc (*(data + 1), out);
	  fputc (*(data++), out);
	  if (depth == 16)
	    data++;
	}
    }
  else
    {
      if (depth==1)
        {
          pixels_per_line/=8;
        }
      for (count = 0; count < (pixels_per_line * lines); count++)
	{
          switch (depth)
            {
              case 8:
	        fputc (*(data + count), out);
                break;
              case 16:
	        fputc (*(data + 1), out);
	        fputc (*(data), out);
	        data += 2;
                break;
              default:
                fputc(data[count], out);
                break;
            }
	}
    }
  fclose (out);

  return;
}


int
main ()
{
  FILE *afile;
  unsigned char *nums;
  unsigned char *buffer, *outbuf;
  unsigned char *fres, *nptr;
  char *eptr = NULL;
  long int lnum;
  int i, j;

  afile = fopen (INFILE, "r");
  if (afile == NULL)
    {
      printf ("file doesnt exist?!");
      return 1;
    }

  buffer = malloc (0x80000);
  nums = malloc (8000000);
  outbuf = malloc (8000000);
  if (!buffer || !nums || !outbuf)
    {
      printf ("no buffers?!");
      free (buffer);
      free (nums);
      free (outbuf);
      return 1;
    }

  fres = nums;
  j = 0;
  i = 0;
  do
    {
      memset (buffer, 0, 0x80000);
      fres = fgets (buffer, 0x80000, afile);
      j++;
      if (fres != NULL)
	{
	  nptr = buffer;
	  errno = 0;
	  lnum = strtol (nptr, &eptr, 16);
	  while ((errno == 0) && ((char *) nptr != eptr) && (i < 8000000))
	    {
	      nums[i] = lnum & 0xff;
	      i++;
	      nptr = eptr;

	      errno = 0;
	      lnum = strtol (nptr, &eptr, 16);
	    }
	}
    }
  while (fres != 0);
  fclose (afile);
  printf ("%d numbers in %d lines read\n", i, j);

  reorder_indexed (nums, outbuf, i);

  write_pnm_file (OUTFILE, outbuf, DEPTH,
			      COLOR_MODE, PIXELS_PER_LINE, SCAN_LINES);
  return 0;
}
