/* sane - Scanner Access Now Easy.

   pie.h

   Copyright (C) 2000 Simon Munton, based on the umax backend by Oliver Rauch
   Copyright (C) 2011 Michael Rickmann <mrickma@gwdg.de>
                 for USB part
   
   This file is part of the SANE package.
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
   
   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.
   
   The exception is that, if you link a SANE library with other files
   to produce an executable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.
   
   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.
   
   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.
   
   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice. 
*/

#ifndef PIE_DEFS_H
#define PIE_DEFS_H

/* --------------- defines moved here from pie.c --------------- */

#define DBG_error0  0
#define DBG_error   1
#define DBG_sense   2
#define DBG_warning 3
#define DBG_inquiry 4

#define DBG_info    5
#define DBG_info2   6
#define DBG_proc    7
#define DBG_read    8
#define DBG_sane_init   10
#define DBG_sane_proc   11
#define DBG_sane_info   12
#define DBG_sane_option 13
#define DBG_dump	14

#define BUILD 10

#define PIE_CONFIG_FILE "pie.conf"

#define LINEART_STR         SANE_VALUE_SCAN_MODE_LINEART
#define HALFTONE_STR        SANE_VALUE_SCAN_MODE_HALFTONE
#define GRAY_STR            SANE_VALUE_SCAN_MODE_GRAY
#define COLOR_STR           SANE_VALUE_SCAN_MODE_COLOR
#define COLOR_IR_STR        "RGBI"

#define LINEART             1
#define HALFTONE            2
#define GRAYSCALE           3
#define RGB                 4
#define RGBI                5

#define CAL_MODE_PREVIEW        (INQ_CAP_FAST_PREVIEW)
#define CAL_MODE_FLATBED        0x00
#define CAL_MODE_ADF            (INQ_OPT_DEV_ADF)
#define CAL_MODE_TRANPSARENCY   (INQ_OPT_DEV_TP)
#define CAL_MODE_TRANPSARENCY1  (INQ_OPT_DEV_TP1)
#define CAL_MODE_FILM_NORMAL	0x00
#define CAL_MODE_FILM_HIQUAL	0x02
#define CAL_MODE_FILM_SKIP	0x08


#define min(a,b) (((a)<(b))?(a):(b))
#define max(a,b) (((a)>(b))?(a):(b))

/* times (in us) to delay after certain commands. Scanner seems to lock up if it returns busy
 * status and commands are repeatedly reissued (by kernel error handler) */

#define DOWNLOAD_GAMMA_WAIT_TIME	(1000000)
#define SCAN_WAIT_TIME			(1000000)
#define SCAN_WARMUP_WAIT_TIME		(500000)
#define TUR_WAIT_TIME			(500000)


/* options supported by the scanner */

enum Pie_Option
{
  OPT_NUM_OPTS = 0,

  /* ------------------------------------------- */
  OPT_MODE_GROUP,
  OPT_MODE,
  OPT_BIT_DEPTH,
  OPT_RESOLUTION,


  /* ------------------------------------------- */

  OPT_GEOMETRY_GROUP,
  OPT_TL_X,			/* top-left x */
  OPT_TL_Y,			/* top-left y */
  OPT_BR_X,			/* bottom-right x */
  OPT_BR_Y,			/* bottom-right y */

  /* ------------------------------------------- */

  OPT_ENHANCEMENT_GROUP,

  OPT_HALFTONE_PATTERN,
  OPT_SPEED,
  OPT_THRESHOLD,

  OPT_GAMMA_VECTOR,
  OPT_GAMMA_VECTOR_R,
  OPT_GAMMA_VECTOR_G,
  OPT_GAMMA_VECTOR_B,

  /* ------------------------------------------- */

  OPT_ADVANCED_GROUP,
  OPT_PREVIEW,

  /* must come last: */
  NUM_OPTIONS
};


/* This defines the information needed during calibration */

struct Pie_cal_info
{
  int cal_type;
  int receive_bits;
  int send_bits;
  int num_lines;
  int pixels_per_line;
};


/* This structure holds the information about a physical scanner */

typedef struct Pie_Device
{
  struct Pie_Device *next;

  char *devicename;		/* name of the scanner device */

  char vendor[9];		/* will be xxxxx */
  char product[17];		/* e.g. "SuperVista_S12" or so */
  char version[5];		/* e.g. V1.3 */

  SANE_Int model;		/* currently 0 for SCSI, > 0 for USB scanners */
  SANE_Device sane;
  SANE_Range dpi_range;
  SANE_Range x_range;
  SANE_Range y_range;

  SANE_Range exposure_range;
  SANE_Range shadow_range;
  SANE_Range highlight_range;

  int inquiry_len;		/* length of inquiry return block */

  int inquiry_x_res;		/* maximum x-resolution */
  int inquiry_y_res;		/* maximum y-resolution */
  int inquiry_pixel_resolution;
  double inquiry_fb_width;	/* flatbed width in inches */
  double inquiry_fb_length;	/* flatbed length in inches */

  int inquiry_trans_top_left_x;
  int inquiry_trans_top_left_y;
  double inquiry_trans_width;	/* transparency width in inches */
  double inquiry_trans_length;	/* transparency length in inches */

  int inquiry_halftones;	/* number of halftones supported */
  int inquiry_filters;		/* available colour filters */
  int inquiry_color_depths;	/* available colour depths */
  int inquiry_color_format;	/* colour format from scanner */
  int inquiry_image_format;	/* image data format */
  int inquiry_scan_capability;	/* additional scanner features, number of speeds */
  int inquiry_optional_devices;	/* optional devices */
  int inquiry_enhancements;	/* enhancements */
  int inquiry_gamma_bits;	/* no of bits used for gamma table */
  int inquiry_fast_preview_res;	/* fast preview resolution */
  int inquiry_min_highlight;	/* min highlight % that can be used */
  int inquiry_max_shadow;	/* max shadow % that can be used */
  int inquiry_cal_eqn;		/* which calibration equation to use */
  int inquiry_min_exp;		/* min exposure % */
  int inquiry_max_exp;		/* max exposure % */

  SANE_String scan_mode_list[7];	/* holds names of types of scan (color, ...) */

  SANE_Word bpp_list[4];	/* USB film scanners: 8, 16 */

  SANE_String halftone_list[17];	/* holds the names of the halftone patterns from the scanner */

  SANE_String speed_list[9];	/* holds the names of available speeds */

  int cal_info_count;		/* number of calibration info sets */
  struct Pie_cal_info *cal_info;	/* points to the actual calibration information */
}
Pie_Device;

/* This structure holds information about an instance of an 'opened' scanner */

typedef struct Pie_Scanner
{
  struct Pie_Scanner *next;
  Pie_Device *device;		/* pointer to physical scanner */

  int sfd;			/* scanner file desc. */
  int bufsize;			/* max scsi buffer size */

  SANE_Option_Descriptor opt[NUM_OPTIONS];	/* option descriptions for this instance */
  Option_Value val[NUM_OPTIONS];	/* option settings for this instance */
  SANE_Int *gamma_table[4];	/* gamma tables for this instance */
  SANE_Range gamma_range;
  int gamma_length;		/* size of gamma table */

  int scanning;			/* true if actually doing a scan */
  SANE_Parameters params;

  SANE_Pid reader_pid;
  int pipe;
  int reader_fds;

  int colormode;		/* whether RGB, GRAY, LINEART, HALFTONE */
  int resolution;
  int cal_mode;			/* set to value to compare cal_info mode to */

  int cal_filter;		/* set to indicate which filters will provide data for cal */

  int filter_offset1;		/* offsets between colors in indexed scan mode */
  int filter_offset2;

  int bytes_per_line;		/* number of bytes per line */

}
Pie_Scanner;

#define DBG_DUMP(level, buf, n)	{ if (DBG_LEVEL >= (level)) pie_dump_buffer(level,buf,n); }


/* --------------- defines for the USB code --------------- */

#define ENABLE_OPT(OPTION)  scanner->opt[OPTION].cap &= ~SANE_CAP_INACTIVE
#define DISABLE_OPT(OPTION) scanner->opt[OPTION].cap |=  SANE_CAP_INACTIVE
#define IS_ACTIVE_OPT(OPTION) (((scanner->opt[OPTION].cap) & SANE_CAP_INACTIVE) == 0)


#define BULKIN_MAXSIZE          0xFFF0
#define BUFFER_MAXSIZE          0x7F000

/* USB control message values */

#define REQUEST_TYPE_IN		(USB_TYPE_VENDOR | USB_DIR_IN)
#define REQUEST_TYPE_OUT	(USB_TYPE_VENDOR | USB_DIR_OUT)

#define REQUEST_REGISTER	0x0c
#define REQUEST_BUFFER		0x04

#define VALUE_BUFFER		0x82
#define VALUE_READ_REGISTER	0x84
#define VALUE_WRITE_REGISTER	0x85
#define VALUE_INIT_1		0x87
#define VALUE_INIT_2		0x88

#define INDEX			0x00

/* e.g.
   control  0x40 0x0c 0x87 0x00 len     1 wrote 0x04
            REQUEST_TYPE_OUT
                 REQUEST_REGISTER
                      VALUE_INIT_1
                           INDEX
*/


typedef struct PIE_USB_Device_Entry
{
  SANE_Word vendor;		/* USB vendor identifier */
  SANE_Word product;		/* USB product identifier */
  SANE_Word model;		/* currently only count >= 1 */
} PIE_USB_Device_Entry;

typedef struct PIE_USB_Value_Data	/* USB control sequence element */
{
  SANE_Byte bValue;
  SANE_Byte bData;
} PIE_USB_Value_Data;

typedef struct PIE_USB_Calibration_Read
{
  unsigned char dont_care_1[66];
  unsigned char copy_1[6];
  unsigned char r_gain;
  unsigned char g_gain;
  unsigned char b_gain;
  unsigned char time_val;
  unsigned char dont_care_2[22];
  unsigned char copy_2[5];
} __attribute__ ((__packed__)) PIE_USB_Calibration_Read;

typedef struct PIE_USB_Calibration_Send
{
  unsigned char scsi_cmd[6];
  uint16_t red_texp;
  uint16_t green_texp;
  uint16_t blue_texp;
  unsigned char copy_1[6];
  unsigned char red_gain;
  unsigned char green_gain;
  unsigned char blue_gain;
  unsigned char some_time[3];
  unsigned char copy_2[5];
} __attribute__ ((__packed__)) PIE_USB_Calibration_Send;


#endif	/* not PIE_DEFS_H */

